/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.compat.jei.smelter;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.deepresonance.compat.jei.smelter.SmelterRecipeWrapper;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.SmelterConfig;
import mcjty.lib.varia.ComponentFactory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class SmelterRecipeCategory
implements IRecipeCategory<SmelterRecipeWrapper> {
    private final IGuiHelper guiHelper;
    private final IDrawable slot;
    private final IDrawable arrow;
    private final IDrawable icon;
    private final IDrawable background;
    public static final ResourceLocation ID = new ResourceLocation("deepresonance", "smelter");

    public SmelterRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)MachinesModule.SMELTER_BLOCK.get()));
        this.arrow = guiHelper.createDrawable(new ResourceLocation("deepresonance", "textures/gui/guielements.png"), 144, 0, 16, 16);
        this.background = guiHelper.createBlankDrawable(120, 60);
    }

    public Component getTitle() {
        return ComponentFactory.literal((String)"Deep Resonance Smelter");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends SmelterRecipeWrapper> getRecipeClass() {
        return SmelterRecipeWrapper.class;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(SmelterRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.slot.draw(stack, 20, 32);
        this.arrow.draw(stack, 46, 32);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        fontRenderer.m_92883_(stack, "Tank below between", 10.0f, 0.0f, -1);
        fontRenderer.m_92883_(stack, "40% and 60% lava", 10.0f, 10.0f, -1);
    }

    public void setIngredients(SmelterRecipeWrapper recipe, IIngredients ingredients) {
        ingredients.setInputLists((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(List.of(new ItemStack((ItemLike)CoreModule.RESONATING_ORE_STONE_ITEM.get()), new ItemStack((ItemLike)CoreModule.RESONATING_ORE_END_ITEM.get()), new ItemStack((ItemLike)CoreModule.RESONATING_ORE_NETHER_ITEM.get()), new ItemStack((ItemLike)CoreModule.RESONATING_ORE_DEEPSLATE_ITEM.get()))));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)CoreModule.LIQUID_CRYSTAL.get(), ((Integer)SmelterConfig.RCL_PER_ORE.get()).intValue()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, SmelterRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.init(0, true, 20, 32);
        group.set(0, List.of(new ItemStack((ItemLike)CoreModule.RESONATING_ORE_DEEPSLATE_BLOCK.get()), new ItemStack((ItemLike)CoreModule.RESONATING_ORE_END_BLOCK.get()), new ItemStack((ItemLike)CoreModule.RESONATING_ORE_NETHER_BLOCK.get()), new ItemStack((ItemLike)CoreModule.RESONATING_ORE_STONE_BLOCK.get())));
        IGuiFluidStackGroup fluidGroup = recipeLayout.getFluidStacks();
        fluidGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            tooltip.add(ComponentFactory.literal((String)"Purity: 10%").m_130940_(ChatFormatting.GREEN));
            tooltip.add(ComponentFactory.literal((String)"Strength: 10%").m_130940_(ChatFormatting.GREEN));
            tooltip.add(ComponentFactory.literal((String)"Efficiency: 10%").m_130940_(ChatFormatting.GREEN));
        });
        fluidGroup.init(0, false, 70, 25, 30, 30, ((Integer)SmelterConfig.RCL_PER_ORE.get()).intValue(), true, null);
        fluidGroup.set(0, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
    }
}

